<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<main>
    <!-- Modal Trigger -->
    <div class="container">
        <div class="row">

            <div class="col s2"><a href="#modal1"
                                   class="modal-trigger btn-floating btn-large waves-effect waves-light tooltipped indigo"
                                   data-position="right" data-delay="50"
                                   data-tooltip="<?php echo $competition_text['competition_add_btn_tooltip']; ?>"><i
                            class="material-icons">add</i></a>
            </div>
        </div>
        <div class="row">
            <span style="font-weight: bold"><?php echo $competition_text['competition_description_task'] ?> </span>
        </div>
    </div>
</main>
<body>




<!-- Modal Structure -->
<div id="modal1" class="modal z-depth-5">
    <form method="post" action="<?php echo base_url() ?>competition/create">
        <div class="modal-content">
            <div class="row indigo lighten-3">
                <span style="font-weight:bold"><?php echo $competition_text['competition_create_text1'] ?></span> <br>
                <span style="font-weight:bold"> <i
                            class="material-icons">warning</i> <?php echo $competition_text['competition_create_text2'] ?></span>
            </div>
            <!--            <div class="row">-->
            <!--                <i class="material-icons ">warning</i> Rellene los campos obligatorios antes de crear la competición-->
            <!---->
            <!--            </div>-->
            <div class="row">
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">create</i>
                    <input id="icon_name" type="text" name="nombre" required maxlength="30" data-length="30">
                    <label for="icon_name"><?php echo $competition_text['competition_create_name']; ?>(*)</label>
                </div>
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">date_range</i>
                    <input type="date" name="fecha" id="fecha" required/>
                    <label for="fecha"><?php echo $competition_text['competition_create_date']; ?>(*)</label>

                </div>
            </div>
            <div class="row">
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">list</i>

                    <select name="paisISOA3">
                        <option value="" disabled
                                selected><?php echo $competition_text['competition_create_country']; ?></option>
                        <option value="ESP">España</option>
                        <option value="ALE">Alemania</option>
                        <option value="FRE">Francia</option>

                    </select>
                </div>
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">create</i>
                    <input type="text" name="autonomia" required  maxlength="30" data-length="30" id="autonomia"/>
                    <label for="autonomia"><?php echo $competition_text['competition_create_community']; ?>(*)</label>
                </div>
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">create</i>
                    <input type="text" name="provincia" required  maxlength="30" data-length="30" id="provincia"/>
                    <label for="provincia"><?php echo $competition_text['competition_create_province']; ?>(*)</label>
                </div>

            </div>
            <div class="row">
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">create</i>
                    <input type="text" name="pabellon"   maxlength="30" data-length="30" id="pabellon"/>
                    <label for="pabellon"><?php echo $competition_text['competition_create_sport_center']; ?></label>
                </div>
                <div class="input-field col s12 xl6">

                    <i class="material-icons prefix">format_list_numbered</i>

                    <select name="numeroDeTatamis" id = "mat">
                        <option value="" disabled
                                selected><?php echo $competition_text['competition_create_number_of_mats']; ?></option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                        <option value="6">6</option>
                    </select>
                    <label><?php echo $competition_text['competition_create_number_of_mats']; ?>(*)</label>
                </div>


            </div>
            <div class="row">
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">list</i>
                    <select name="tipoCompeticion">
                        <option value="" disabled
                                selected><?php echo $competition_text['competition_create_category']; ?>
                        </option>
                        <?php foreach ($competitionType as $type) { ?>
                            <option value="<?php echo $type->idTipoCompeticion; ?>"><?php echo $type->descripcion; ?></option>
                        <?php } ?>
                    </select>
                    <label><?php echo $competition_text['competition_create_category']; ?></label>
                </div>
                <div class="input-field col s12 xl6">
                    <i class="material-icons prefix">list</i>
                    <select name="grupoEdad" id="idTypeCompetition">
                        <option value="" disabled
                                selected><?php echo $competition_text['competition_create_age_group']; ?>
                        </option>
                        <?php foreach ($ageGroup as $categorie) { ?>
                            <option value="<?php echo $categorie->idGrupoEdad; ?>"><?php echo $categorie->descripcion; ?></option>
                        <?php } ?>
                    </select>
                    <label><?php echo $competition_text['competition_create_age_group']; ?>(*)</label>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button onclick="return validateMandatoryFields()" class="btn btn-large waves-effect indigo"><?php echo $competition_text['competition_create_btn']; ?></button>
        </div>
    </form>
</div>
<div class="container">
    <div class="row">
        <?php foreach ($competitions as $competition) { ?>
            <div class="col s12 xl5 ">
                <div class="card  z-depth-5 ">

                    <div class="card-content white-text">
                        <blockquote>
                            <span class="card-title indigo-text "><?php echo $competition->nombre ?></span>

                            <a
                                    onclick="return confirm('<?php echo $competition_text['competition_confirm_delete'] ?>')"
                                    href="<?php echo base_url() ?>competition/delete/<?php echo $competition->idCompeticion ?>"
                                    class="waves-effect waves-light btn red lighten-2"><?php echo $competition_text['competition_delete_btn']; ?>
                                <i class="material-icons right">delete</i></a>


                        </blockquote>


                        <table class="align-center responsive-table">
                            <thead>
                            <tr>

                                <th><?php echo $competition_text['competition_create_date'] ?></th>
                                <th><?php echo $competition_text['competition_create_age_group'] ?></th>
                                <th><?php echo $competition_text['competition_create_sport_center'] ?></th>

                            </tr>
                            </thead>

                            <tbody>
                            <tr>

                                <td><?php echo $competition->fecha ?></td>
                                <td><?php echo $competition->geDescripcion ?></td>
                                <td><?php echo $competition->pabellon ?></td>
                            </tr>

                            </tbody>
                        </table>
                        <hr>
                    </div>
                    <div class="card-action ">


                        <div class="row ">
                            <ul>
                                <li class="center">
                                    <a class="tooltipped btn teal lighten-3 "
                                       data-position="behind" data-delay="50"
                                       data-tooltip="<?php echo $competition_text['competition_tooltip_mats']; ?>"
                                       style="color: #FFFFFF;width: 100%"
                                       href="<?php echo base_url() ?>viewcompetition/<?php echo $competition->idCompeticion ?>"><?php echo $competition_text['competition_card_mats']; ?><i class="material-icons right">visibility</i>
                                    </a>
                                </li>
                                <br>
                                <li class="center">
                                    <a
                                            class="tooltipped btn blue-grey "
                                            data-position="behind" data-delay="50"
                                            data-tooltip="<?php echo $competition_text['competition_tooltip_competitor_inscription']; ?>"
                                            style="color: #FFFFFF; width: 100%"
                                            href="<?php echo base_url() ?>competitor_inscription/<?php echo $competition->idCompeticion ?>"><?php echo $competition_text['competition_card_competitor_inscription']; ?><i class="material-icons right">visibility</i>
<!--                                        --><?php //echo strtotime($competition -> fecha ) <  strtotime(date('Y-m-d') )? "<i class='material-icons right'>visibility_off</i>" : "<i class='material-icons right'>visibility</i>" ?>
                                    </a>
                                </li>
                                <br>
                                <li class="center">
                                    <a
                                            class="tooltipped btn  brown lighten-2 "
                                            data-position="behind" data-delay="50"
                                            data-tooltip="<?php echo $competition_text['competition_tooltip_referee_inscription']; ?>"
                                            style="color: #FFFFFF; width: 100%"
                                            href="<?php echo base_url() ?>referee_inscription/<?php echo $competition->idCompeticion ?>"><?php echo $competition_text['competition_card_referee_inscription']; ?><i class="material-icons right">visibility</i>
<!--                                        --><?php //echo strtotime($competition -> fecha ) <  strtotime(date('Y-m-d') )? "<i class='material-icons right'>visibility_off</i>" : "<i class='material-icons right'>visibility</i>" ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        </a>

                        <hr>


                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php echo $this->pagination->create_links(); ?>
</div>

</body>

<script>
    function validateMandatoryFields() {
        var mat = $('#mat').val();
        var typeOfCompetition = $('#idTypeCompetition').val();
        var date = $('#fecha').val();

        if(mat == null || typeOfCompetition == null || date == null){
            Materialize.toast('Rellene los campos obligatorios',2000)
            return false;
        }
    }
</script>

